TITLE   'Radiating and Conducting Foil'				{ exa172.pde }
SELECT     errlim=1e-4     spectral_colors     stages=10
COORDINATES
   cartesian1							{ 1D calculation }
VARIABLES   U   temp
DEFINITIONS
   Lx=0.5     d=1e-4     temp0=300       	
   U1=stage*0.1     k=400					{ Copper }
   cond0=1/1.67e-8     cond=cond0*temp0/abs(temp)    	
   Ex=-dx(U)     E=-grad(U)
   Jx=cond*Ex
   fluxd_x=-k*dx( temp)
   heat=Jx*Ex- 2* 0.3*  5.67e-8* (temp^4-300^4)/d	
	   	       { 2 faces, emissivity, Stefan-Boltzmann formula  }
INITIAL VALUES
   U=0   temp=400
EQUATIONS
   U: 		dx( Jx)=0
   temp:	dx( fluxd_x)=heat
BOUNDARIES
region 'domain'
   start (0)  point value( U)=0  point value(temp)=300  line to (Lx)
   point value( U)=U1  point value(temp)=300
PLOTS
   elevation( temp) from (0) to (Lx)  report( U1)
   elevation( fluxd_x) from (0) to (Lx)
END

